/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp

import com.google.devtools.ksp.symbol.KSFunctionDeclaration
import com.google.devtools.ksp.symbol.Modifier

internal val KSFunctionDeclaration.isSuspend
    get() = modifiers.contains(Modifier.SUSPEND)

internal fun String.capitalizeFirstChar(): String {
    return replaceFirstChar { if (it.isTitleCase()) it else it.titlecaseChar() }
}

internal fun String.lowercaseFirstChar(): String {
    return replaceFirstChar { if (it.isLowerCase()) it else it.titlecaseChar() }
}

internal fun List<String>.toCamelCase(): String {
    return this.mapIndexed { index, word ->
        if (index == 0) word.lowercaseFirstChar() else word.capitalizeFirstChar()
    }.joinToString("")
}

internal fun String.removeKotlinExtension(): String {
    return this.removeSuffix(".kt")
}
