/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp

import com.google.devtools.ksp.processing.Resolver
import ru.aurora.kmp.qtbindings.ksp.export.ExportSpec
import ru.aurora.kmp.qtbindings.ksp.export.ExportedFunction
import ru.aurora.kmp.qtbindings.ksp.export.ExportedMethod
import ru.aurora.kmp.qtbindings.ksp.export.ExportedProperty

internal class KotlinScopeManager(private val resolver: Resolver, private val spec: ExportSpec) {

    private val scopes: MutableMap<String, KotlinScope> = mutableMapOf()

    fun getScope(f: ExportedFunction): KotlinScope {
        if (f is ExportedMethod) {
            return getScope(f.parentClass.containingFile.filePackage.components + f.parentClass.name)
        }

        return getScope(f.containingFile.filePackage.components)
    }

    fun getScope(p: ExportedProperty) =
        getScope(p.parentClass.containingFile.filePackage.components + p.parentClass.name)

    private fun getScope(components: List<String>): KotlinScope {
        val component = components.joinToString(".")
        return scopes.getOrPut(component) { KotlinScope(spec, components, resolver) }
    }
}
