/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp.model

internal enum class IncludeType {
    Local,
    System,
}

internal data class QtInclude(
    val type: IncludeType,
    val name: String,
    val extension: String? = null,
) {
    fun asString(): String {
        val include = "$name${if (extension != null) ".$extension" else ""}"
        return when (type) {
            IncludeType.Local -> "\"$include\""
            IncludeType.System -> "<$include>"
        }
    }

    companion object {
        val CoroutineOperationHeader = cppLocalHeader("CoroutineOperation")

        val QFuture = QtInclude(IncludeType.System, "QFuture")
        val QList = QtInclude(IncludeType.System, "QList")
        val QString = QtInclude(IncludeType.System, "QString")

        fun cKotlinApi(libName: String) = cLocalHeader("lib${libName}_api")
        fun cppLocalHeader(name: String) = QtInclude(IncludeType.Local, name, "hpp")
        fun cLocalHeader(name: String) = QtInclude(IncludeType.Local, name, "h")
    }
}
