/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp

import com.squareup.kotlinpoet.AnnotationSpec
import com.squareup.kotlinpoet.TypeName

internal fun createOptInAnnotationSpec(vararg types: TypeName): AnnotationSpec {
    val builder = AnnotationSpec.builder(optInClassName)
    types.forEach { builder.addMember("%T::class", it) }
    return builder.build()
}