/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp

import com.google.devtools.ksp.symbol.KSValueParameter
import com.squareup.kotlinpoet.KModifier
import com.squareup.kotlinpoet.ParameterSpec
import com.squareup.kotlinpoet.ksp.TypeParameterResolver
import com.squareup.kotlinpoet.ksp.toAnnotationSpec
import com.squareup.kotlinpoet.ksp.toTypeName

internal fun KSValueParameter.toParameterSpec(
    typeParameterResolver: TypeParameterResolver
): ParameterSpec {
    val name = name?.asString() ?: ""
    val type = type.toTypeName(typeParameterResolver)
    val builder = ParameterSpec.builder(name, type)
    builder.addAnnotations(annotations.map { it.toAnnotationSpec() }.asIterable())
    if (isVararg) {
        builder.addModifiers(KModifier.VARARG)
    }

    return builder.build()
}
