/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp.model

import ru.aurora.kmp.qtbindings.ksp.TypeConverterDescriptor

internal data class QtFile(
    val fileName: String,
    val dependencyFilePath : String,
    val namespace: QtNamespace,

    val headerIncludes: Set<QtInclude>,
    val sourceInclude: Set<QtInclude>,
    val typeConverters: LinkedHashSet<TypeConverterDescriptor>,

    val classes: List<QtClass>,
    val functions: List<QtFunction>,
)
