/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp.export

/**
 * Describes kotlin class method that needs to be exported to Qt.
 */
internal class ExportedMethod(
    originalName: String,
    val isConstructor: Boolean,
    isAsync: Boolean,
    isExtension: Boolean,
    val parentClass: ExportedClass,
    returnType: ExportedType,
    parameters: List<ExportedParameter> = emptyList(),
) : ExportedFunction(originalName, isAsync, isExtension, parameters, returnType, parentClass.containingFile) {
    override val fqName: String
        get() {
            return "${parentClass.fqName}.$name"
        }
}
