/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp.export

/**
 * Describes kotlin class that needs to be exported to Qt.
 */
internal class ExportedClass(
    val name: String,
    val isDataClass: Boolean,
    val containingFile: ExportedFile,
    val methods: MutableList<ExportedMethod> = mutableListOf(),
    val properties: MutableList<ExportedProperty> = mutableListOf(),
) {
    val fqName get() = "${containingFile.filePackage.name}.$name"
}
