/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.aurora.kmp.qtbindings.ksp

import com.squareup.kotlinpoet.ClassName
import com.squareup.kotlinpoet.MemberName

// Package names

private const val kotlinPackageName = "kotlin"
private const val kotlinCollectionsPackageName = "kotlin.collections"
private const val cinteropPackageName = "kotlinx.cinterop"
private const val kotlinNativePackageName = "kotlin.native"
private const val qtBindingsPackageName = "ru.aurora.kmp.qtbindings"
private const val cRuntimePackageName = "$qtBindingsPackageName.cruntime"

// kotlin package names

internal val anyClassName = ClassName(kotlinPackageName, "Any")
internal val intClassName = ClassName(kotlinPackageName, "Int")
internal val optInClassName = ClassName(kotlinPackageName, "OptIn")
internal val unitClassName = ClassName(kotlinPackageName, "Unit")

// kotlin.collections package names

internal val listClassName = ClassName(kotlinCollectionsPackageName, "List")
internal val mutableListClassName = ClassName(kotlinCollectionsPackageName, "MutableList")

// kotlinx.cinterop package names

internal val cPointerClassName = ClassName(cinteropPackageName, "CPointer")
internal val cOpaquePointerName = ClassName(cinteropPackageName, "COpaquePointer")
internal val experimentalForeignApiClassName = ClassName(cinteropPackageName, "ExperimentalForeignApi")

// kotlin.native package names

internal val cNameClassName = ClassName(kotlinNativePackageName, "CName")

// ru.aurora.kmp.qtbindings package names

internal val kotlinCoroutineLauncherClassName = ClassName(cRuntimePackageName, "KotlinCoroutineLauncher")
internal val qtExportClassName = ClassName(qtBindingsPackageName, "QtExport")
internal val cSuspendFunctionMemberName = MemberName(qtBindingsPackageName, "cSuspend")
internal val listGetSizePredefinedMemberName = MemberName(qtBindingsPackageName, "listGetSizePredefined")
internal val listGetElementByIndexPredefinedMemberName =
    MemberName(qtBindingsPackageName, "listGetElementByIndexPredefined")
internal val mutableListCreateEmptyPredefinedMemberName =
    MemberName(qtBindingsPackageName, "mutableListCreateEmptyPredefined")
internal val mutableListAddClassPredefinedMemberName =
    MemberName(qtBindingsPackageName, "mutableListAddClassPredefined")
internal val mutableListAddSimpleElementPredefinedMemberName =
    MemberName(qtBindingsPackageName, "mutableListAddSimpleElementPredefined")
internal val mutableListToListPredefinedMemberName = MemberName(qtBindingsPackageName, "mutableListToListPredefined")

internal fun String.removePredefinedSuffix(): String {
    return this.removeSuffix("Predefined")
}
