import org.jetbrains.kotlin.gradle.ExperimentalWasmDsl

plugins {
    alias(libs.plugins.kotlin.multiplatform)
    id("maven-publish")
}

kotlin {
    explicitApi()
    jvmToolchain(11)

    // Need to publish for all targets
    iosArm64()
    iosSimulatorArm64()
    iosX64()
    js {
        browser()
        nodejs()
    }
    jvm()
    linuxArm64()
    linuxX64()
    macosArm64()
    macosX64()
    mingwX64()
    tvosArm64()
    tvosSimulatorArm64()
    tvosX64()
    @OptIn(ExperimentalWasmDsl::class)
    wasmJs {
        browser()
        nodejs()
        d8()
    }
    watchosArm32()
    watchosArm64()
    watchosDeviceArm64()
    watchosSimulatorArm64()
    watchosX64()

    val linuxTargets = listOf(linuxArm64(), linuxX64())

    linuxTargets.forEach { target ->
        target.binaries {}
        target.compilations.getByName("main") {
            cinterops {
                val cruntime by creating {
                    defFile("src/nativeInterop/cinterop/cruntime.def")
                }
            }
        }
    }

    sourceSets {
        linuxMain {
            dependencies {
                implementation(kotlin("stdlib"))
                implementation(libs.kotlinx.coroutines.core)
            }
        }
    }
}

group = "ru.aurora.kmp"
version = "0.1.0"

publishing {
    repositories {
        mavenLocal()
    }
}
