/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.auroraos.kmp.qtbindings.ksp.internal

import java.io.File
import kotlin.collections.windowed

open class ProcessResult(
    val executable: File,
    val exitCode: Int,
    val stdout: String,
    val stderr: String,
) {
    val isOk = exitCode == 0
    open fun assertIsOk() = assert(isOk) { "Failed to run executable ${executable.absolutePath} (exitCode=$exitCode): $stderr" }

    fun assertStdoutHas(vararg lines: String) = assertHas(stdout, *lines)
    fun assertStderrHas(vararg lines: String) = assertHas(stderr, *lines)

    fun assertHas(output: String, vararg lines: String) {
        val outputLines = output.lines()

        lines.forEach { it ->
            val contentLines = it.lines()
            val sublistsOfSpecifiedSize = outputLines.windowed(contentLines.size)
            assert(sublistsOfSpecifiedSize.any { it == contentLines }) { "Output does not have: $it" }
        }
    }
}
