/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.auroraos.kmp.qtbindings.ksp.gen

import ru.auroraos.kmp.qtbindings.ksp.*
import ru.auroraos.kmp.qtbindings.ksp.model.QtClass
import ru.auroraos.kmp.qtbindings.ksp.model.QtFunction

internal class CLibraryAPI(val libName: String) {

    val generated = Generated()
    val kotlin = Kotlin()

    inner class Generated {

        val list = List()
        val mutableList = MutableList()

        fun namespace(symbolsVar: String): String =
            this@CLibraryAPI.namespace(symbolsVar, "ru", "auroraos", "kmp", "qtbindings", "generated")

        inner class List {
            val getSizeFun = listGetSizePredefinedMemberName.simpleName.removePredefinedSuffix()
            val getElementByIndexFun = listGetElementByIndexPredefinedMemberName.simpleName.removePredefinedSuffix()
        }

        inner class MutableList {
            val createEmpty = mutableListCreateEmptyPredefinedMemberName.simpleName.removePredefinedSuffix()
            val addClass = mutableListAddClassPredefinedMemberName.simpleName.removePredefinedSuffix()
            val addUnit = "mutableListAddUnit"
            val addBool = "mutableListAddBoolean"
            val addChar = "mutableListAddChar"
            val addByte = "mutableListAddByte"
            val addShort = "mutableListAddShort"
            val addInt = "mutableListAddInt"
            val addLong = "mutableListAddLong"
            val addUByte = "mutableListAddUByte"
            val addUShort = "mutableListAddUShort"
            val addUInt = "mutableListAddUInt"
            val addULong = "mutableListAddULong"
            val addFloat = "mutableListAddFloat"
            val addDouble = "mutableListAddDouble"
            val addString = "mutableListAddString"
            val toList = mutableListToListPredefinedMemberName.simpleName.removePredefinedSuffix()
        }
    }

    inner class Kotlin {
        val list = "lib${libName}_kref_kotlin_collections_List"
        val mutableList = "lib${libName}_kref_kotlin_collections_MutableList"
        val symbolsMethodName = "lib${libName}_symbols"

        fun className(fqName: String): String {
            return "lib${libName}_kref_${fqName.replace("::", "_")}"
        }
    }

    fun namespace(symbolsVar: String, vararg ns: String): String {
        return "${symbolsVar}->kotlin.root.${ns.joinToString(".")}"
    }

    fun namespace(symbolsVar: String, ns: List<String>): String {
        return "${symbolsVar}->kotlin.root.${ns.joinToString(".")}"
    }

    fun classNamespace(symbolsVar: String, qtClass: QtClass): String {
        val ns = qtClass.ns.components.joinToString(".")
        return "${symbolsVar}->kotlin.root.${ns}.${qtClass.name}"
    }

    fun topLevelFunctionNamespace(symbolsVar: String, qtFunction: QtFunction): String {
        return namespace(symbolsVar, qtFunction.ns.components)
    }

    fun getKotlinListType(listConverter: TypeConverterDescriptor): String {
        return when (listConverter) {
            is TypeConverterDescriptor.List -> getKotlinListType(listConverter.isMutable)
        }
    }

    fun getKotlinListType(isMutable: Boolean): String {
        return if (isMutable) kotlin.mutableList else kotlin.list
    }
}
