/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.auroraos.kmp.qtbindings.ksp.export

import com.google.devtools.ksp.symbol.KSValueParameter

/**
 * Describes kotlin parameter that needs to be exported to Qt.
 */
internal data class ExportedParameter(
    val name: String,
    val type: ExportedType,
)


internal fun KSValueParameter.toExportParameter(userDefinedClasses: List<ExportedClass>): ExportedParameter? {
    // Vararg and default parameter are not supported
    // The default parameter is exported, but becomes non-default
    if (isVararg) return null
    val type = type.toExportedType(userDefinedClasses) ?: return null
    val name = name?.asString() ?: return null
    return ExportedParameter(name, type)
}
