/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.auroraos.kmp.qtbindings.ksp.export

/**
 * Describes kotlin top level function that needs to be exported to Qt.
 */
internal open class ExportedFunction(
    val originalKotlinName: String,
    val isAsync: Boolean,
    val isExtension: Boolean,
    val parameters: List<ExportedParameter> = emptyList(),
    val returnType: ExportedType,
    val containingFile: ExportedFile,
) {
    // For asynchronous functions, we generate wrappers with the Async suffix
    open val name = if (isAsync) "${originalKotlinName}Async" else originalKotlinName
    open val fqName = "${containingFile.filePackage.name}.$name"
}
