/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.auroraos.kmp.qtbindings.ksp.export

import com.google.devtools.ksp.symbol.KSFile

/**
 * Describes kotlin file that needs to be exported to Qt.
 */
internal class ExportedFile(
    val fileName: String,
    val dependencyFilePath : String,
    val filePackage: ExportedPackage,
    val classes: MutableList<ExportedClass> = mutableListOf(),
    val functions: MutableList<ExportedFunction> = mutableListOf(),
)
