/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.auroraos.kmp.qtbindings.ksp.export

import com.google.devtools.ksp.processing.CodeGenerator
import com.google.devtools.ksp.symbol.KSFile
import com.squareup.kotlinpoet.FileSpec
import com.squareup.kotlinpoet.ksp.writeTo

/**
 * Describes additional kotlin data that has to be generated.
 */
internal class ExportKotlinSpec(private val codeGenerator: CodeGenerator) {
    private val fileSpecBuilders = mutableMapOf<String, FileSpec.Builder>()

    fun getFileSpecBuilder(ksFile: KSFile): FileSpec.Builder = fileSpecBuilders.getOrPut(ksFile.filePath) {
        FileSpec.builder(ksFile.packageName.asString(), ksFile.fileName.removeSuffix(".kt"))
    }

    fun generate() {
        fileSpecBuilders.forEach { _, builder ->
            builder.build().writeTo(codeGenerator, true)
        }
        fileSpecBuilders.clear()
    }
}
