/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.auroraos.kmp.qtbindings.ksp

import com.google.devtools.ksp.symbol.KSClassDeclaration
import com.squareup.kotlinpoet.ClassName
import com.squareup.kotlinpoet.FunSpec

internal fun generateCopyNoArgs(s: KSClassDeclaration): FunSpec {
    val packageName = s.packageName.asString()
    val name = s.simpleName.asString()
    val classType = ClassName(packageName, name)
    return FunSpec.builder("${name}CopyNoArgs").receiver(classType).returns(classType).addCode("return copy()").build()
}
