plugins {
    alias(libs.plugins.kotlin.jvm)
    alias(libs.plugins.kotlinx.kover)
    id("maven-publish")
}

dependencies {
    implementation(libs.ksp.api)
    implementation(libs.kotlin.poet)
    implementation(libs.kotlin.poet.ksp)

    testImplementation(libs.kotlin.test)
    testImplementation(libs.compiler.test.ksp)
    testImplementation(gradleApi())
    testImplementation(libs.kotlin.compiler.embeddable)
    testImplementation(libs.kotlin.gradle.plugin)
    testImplementation(project((":qtbindings-annotations")))
}

kotlin {
    explicitApi()
    jvmToolchain(11)
}

java {
    withSourcesJar()
}

publishing {
    publications {
        create<MavenPublication>("maven") {
            from(components["java"])
        }
    }

    repositories {
        mavenLocal()
    }
}

// TODO: find another way to add dependencies for tests. Now dependencies are published to the Maven Local
tasks.test {
    val testCompilationDependencies = listOf("qtbindings-annotations", "qtbindings-core")
    testCompilationDependencies.forEach {
        dependsOn(project.rootProject.project(it).tasks.publishToMavenLocal)
    }
}
