/**
 * SPDX-FileCopyrightText: Copyright 2025 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
package ru.auroraos.kmp.qtbindings.gradle.plugin

import org.gradle.process.CommandLineArgumentProvider

internal class QtBindingsCommandLineArgumentProvider(
    private val extension: QtBindingsExtension
): CommandLineArgumentProvider {
    override fun asArguments(): Iterable<String> = listOfNotNull(
        "qtBindings.libName=${extension.libName.get()}"
    )
}
