plugins {
    alias(libs.plugins.kotlin.jvm)
    alias(libs.plugins.gradle.publish)
}

kotlin {
    explicitApi()
    jvmToolchain(11)
}

java {
    withJavadocJar()
    withSourcesJar()
}

dependencies {
    implementation(libs.ksp.gradle.plugin)
    implementation(libs.kotlin.gradle.plugin)
}

val copyVersionTemplate by tasks.registering(Copy::class) {
    inputs.property("version", version)
    from(layout.projectDirectory.file("Version.kt"))
    into(layout.buildDirectory.dir("generated/qt-bindings-version/main"))
    expand("version" to "$version")
    filteringCharset = "UTF-8"
}

tasks.compileKotlin {
    dependsOn(copyVersionTemplate)
}

val sourcesJar by tasks.getting(Jar::class) {
    dependsOn(copyVersionTemplate)
}

// Add Version.kt to the compilation sources
sourceSets {
    main {
        java.srcDir(layout.buildDirectory.dir("generated/qt-bindings-version/main"))
    }
}

gradlePlugin {
    plugins {
        create("qtBindings") {
            id = "ru.auroraos.kmp.qtbindings"
            displayName = "QtBindings"
            description = "Gradle plugin for generating Qt bindings for Kotlin code"
            implementationClass = "ru.auroraos.kmp.qtbindings.gradle.plugin.QtBindingsPlugin"
        }
    }
}
