/*
 * Copyright 2014-2025 JetBrains s.r.o and contributors. Use of this source code is governed by the Apache 2.0 license.
 */

import ktorbuild.createCInterop

plugins {
    id("ktorbuild.project.library")
    id("kotlinx-serialization")
    id("test-server")
}

kotlin {
    createCInterop("winhttp", sourceSet = "windows")

    sourceSets {
        windowsMain.dependencies {
            api(project(":ktor-client:ktor-client-core"))
            api(project(":ktor-http:ktor-http-cio"))
        }
        windowsTest.dependencies {
            implementation(project(":ktor-client:ktor-client-test-base"))
            api(project(":ktor-client:ktor-client-plugins:ktor-client-logging"))
            api(project(":ktor-client:ktor-client-plugins:ktor-client-json"))
        }
    }
}
