/*
 * Copyright 2014-2019 JetBrains s.r.o and contributors. Use of this source code is governed by the Apache 2.0 license.
 */

package io.ktor.client.request

import io.ktor.http.*

/**
 * Sets the [HttpRequestBuilder.url] from [url].
 */
fun HttpRequestBuilder.url(url: java.net.URL): Unit = this.url.takeFrom(url)

/**
 * Constructs a [HttpRequestBuilder] from [url].
 */
operator fun HttpRequestBuilder.Companion.invoke(url: java.net.URL): HttpRequestBuilder =
    HttpRequestBuilder().apply { url(url) }
