package io.ktor.network.tls.extensions

/**
 * Elliptic curve point format
 * @property code numeric point format code
 */
enum class PointFormat(val code: Byte) {
    /**
     * Curve point is not compressed
     */
    UNCOMPRESSED(0),

    /**
     * Point is compressed according to ANSI X9.62
     */
    ANSIX962_COMPRESSED_PRIME(1),

    /**
     * Point is compressed according to ANSI X9.62
     */
    ANSIX962_COMPRESSED_CHAR2(2);
}

/**
 * List of supported curve point formats
 */
val SupportedPointFormats: List<PointFormat> = listOf(
    PointFormat.UNCOMPRESSED,
    PointFormat.ANSIX962_COMPRESSED_PRIME,
    PointFormat.ANSIX962_COMPRESSED_CHAR2
)
