/*
 * Copyright 2014-2019 JetBrains s.r.o and contributors. Use of this source code is governed by the Apache 2.0 license.
 */

package io.ktor.client.tests

import io.ktor.client.call.*
import io.ktor.client.request.*
import io.ktor.client.response.*
import io.ktor.client.tests.utils.*
import io.ktor.http.*
import io.ktor.util.*
import kotlinx.coroutines.*
import io.ktor.utils.io.core.*
import kotlin.test.*

class FullFormTest : ClientLoader() {
    @Test
    fun testGet() = clientTests {
        test { client ->
            val text = client.call {
                url {
                    protocol = URLProtocol.HTTP
                    host = "127.0.0.1"
                    port = 8080
                    encodedPath = "/forms/hello"
                    method = HttpMethod.Get
                }
            }.use { it.response.readText() }

            assertEquals("Hello, client", text)
        }
    }

    @Test
    fun testPost() = clientTests {
        test { client ->
            val text = client.call {
                url {
                    protocol = URLProtocol.HTTP
                    host = "127.0.0.1"
                    port = 8080
                    encodedPath = "/forms/hello"
                    method = HttpMethod.Post
                    body = "Hello, server"
                }
            }.use { it.response.readText() }

            assertEquals("Hello, client", text)
        }
    }

    @Test
    fun testRequest() = clientTests {
        test { client ->
            val requestBuilder = request {
                url {
                    host = "127.0.0.1"
                    protocol = URLProtocol.HTTP
                    port = 8080
                    encodedPath = "/forms/hello"
                    method = HttpMethod.Post
                    body = "Hello, server"
                }
            }

            val body = client.request<String>(requestBuilder)
            assertEquals("Hello, client", body)
        }
    }

    @Test
    fun testCustomUrls() = clientTests {
        val urls = listOf(
            "https://google.com",
            "https://kotlinlang.org/"
        )

        test { client ->
            urls.forEach {
                client.get<String>(it)
            }
        }
    }
}
