package org.jetbrains.ktor.tests

import org.jetbrains.ktor.http.*
import org.jetbrains.ktor.util.*
import org.openjdk.jmh.annotations.*

@State(Scope.Benchmark)
open class ValuesMapBenchmark {
    val headers = valuesOf("A" to listOf("B"), "C" to listOf("D"))

    @Benchmark
    fun valuesOfSingle(): ValuesMap {
        return valuesOf("A" to listOf("B"))
    }

    @Benchmark
    fun valuesOfMany(): ValuesMap {
        return valuesOf("A" to listOf("B"), "C" to listOf("D"))
    }

    @Benchmark
    fun build(): ValuesMap {
        return ValuesMap.build {
            append("A", "B")
            append("C", "D")
        }
    }

    @Benchmark
    fun filter(): ValuesMap {
        return headers.filter { name, value -> true }
    }

    @Benchmark
    fun compression(): ValuesMap {
        return ValuesMap.build(true) {
            appendFiltered(headers) { name, value -> !name.equals(HttpHeaders.ContentLength, true) }
            append(HttpHeaders.ContentEncoding, "deflate")
        }
    }
}

/*
Benchmark                           Mode  Cnt       Score      Error   Units
ValuesMapBenchmark.build           thrpt   10   10062.523 ±  636.484  ops/ms
ValuesMapBenchmark.compression     thrpt   10    4501.705 ±   73.952  ops/ms
ValuesMapBenchmark.filter          thrpt   10    9073.771 ±  662.824  ops/ms
ValuesMapBenchmark.valuesOfMany    thrpt   10   13795.421 ± 1234.157  ops/ms
ValuesMapBenchmark.valuesOfSingle  thrpt   10  123127.741 ± 2750.144  ops/ms
 */

fun main(args: Array<String>) {
    benchmark(args) {
        run<ValuesMapBenchmark>()
    }
}
