## Maven Local

Для получения необходимого проекта в [Maven Local Repositories](https://maven.apache.org/repositories/local.html)
его необходимо собрать самостоятельно, либо клонировать проект с уже собранными артефактами.

## Сборка

Для публикации проекта в `Maven Local` необходимо выполнить его сборку.
Например для получение плагина QtBindings нам нужно:

1. Клонировать открытый проект из mos.hub:

```shell
git clone https://hub.mos.ru/auroraos/kotlin-multiplatform/qt-bindings.git
```

2. Перейти в директорию с проектом и выполнить команду:

```shell
./gradlew publishToMavenLocal
```

Эта команда соберет проект и опубликует его в `Maven Local`.

> Для получение информации по сборке проектов KMP c поддержкой ОС Аврора ознакомьтесь с README.md конкретного проекта.

## Maven Local Repo

Альтернативный способ получить `Maven Local`,
со всеми артефактами KMP поддерживающие ОС Аврора,
это клонировать открытый проект Aurora Maven.

1. Получаем репозиторий:

```bash
wget https://hub.mos.ru/auroraos/kotlin-multiplatform/aurora-maven/-/archive/master/aurora-maven-master.zip
```

2. Распаковываем архив:

```bash
unzip aurora-maven-master.zip
```

3. Копируем содержимое в локальный maven:

```bash
mkdir -p ~/.m2/repository && cp -fR aurora-maven-master/* ~/.m2/repository
```

4. Убираем за собой:

```bash
rm -rf ./aurora-maven-master*
```

## Подключение Maven Local

Для активации `Maven Local` в проекте, необходимо добавить `mavenLocal()` в файле `settings.gradle.kts`:

```kotlin
pluginManagement {
    repositories {
        google()
        gradlePluginPortal()
        mavenCentral()
        mavenLocal()
    }
}

dependencyResolutionManagement {
    repositories {
        google()
        mavenCentral()
        mavenLocal()
    }
}
```