## StudentBox

**[<span class="icon material-symbols-outlined">link</span>mos.hub](https://hub.mos.ru/auroraos/kotlin-multiplatform/examples/student-box)**

StudentBox - приложение позволяющие записывать и редактировать список уроков на день для студента/ученика.
Приложение является примером создания приложения с использованием QtBindings в KMP.
Основная цель - показать как создать и использовать QtBindings в проекте для ОС Аврора.

Включает:

- Запись уроков на день.
- Редактирование списка уроков.

### Структура проекта

![preview](../../assets/images/examples/student-box/structure_ru.png)

### KMP

- Получение названия приложения в зависимости от платформы.
- База данных
    - Получение дней с уроками.
    - Получения дня с уроками.
    - Обновление уроков.
- Сборка библиотеки aar.
- Сборка статической С библиотеки.
- Создание bindings для Qt.
- Http запрос с использованием Ktor.

#### Libs

* [Ktor](https://ktor.io/docs/welcome.html).
* [SQLDelight](https://sqldelight.github.io/sqldelight/2.0.2/).
* [Coroutines](https://kotlinlang.org/docs/coroutines-overview.html).
* [Serialization](https://kotlinlang.org/docs/serialization.html).
* [kotlinx-datetime](https://github.com/Kotlin/kotlinx-datetime).
* [Ksp](https://kotlinlang.org/docs/ksp-overview.html).
* [QtBindings](../qt-bindings/main.md).

### Android

Нативное для платформы приложение Android с использованием библиотеки KMP.

#### Libs

* [Ktor](https://ktor.io/docs/welcome.html).
* [Jetpack Compose](https://developer.android.com/compose).
* [Hilt](https://developer.android.com/training/dependency-injection/hilt-android).
* [Navigation](https://developer.android.com/develop/ui/compose/navigation).
* [Serialization](https://kotlinlang.org/docs/serialization.html).
* [kotlinx-datetime](https://github.com/Kotlin/kotlinx-datetime).
* [Ksp](https://kotlinlang.org/docs/ksp-overview.html).

### ОС Аврора

Нативное приложение ОС Аврора c использованием статической библиотеки KMP и созданных привязок QtBindings.
В проекте привязки отделены от самого проекта через субдиректории Qt.
Субдиректория с привязками собирается в статическую библиотеку и добавляется в основной проект.

### Снимки экранов

<img height="600px" src="../../assets/images/examples/student-box/preview_android_ru.png"/>
<img height="600px" src="../../assets/images/examples/student-box/preview_aurora_ru.png"/>
