# Shared Preferences Secure

Библиотека позволяет хранить настройки в виде пар ключ-значение с шифрованием данных.

### Features:

- Set/Get Boolean.
- Set/Get Int.
- Set/Get Long.
- Set/Get Float.
- Set/Get Double.
- Set/Get String.
- Set/Get List<String>.
- Проверьте, существует ли значение.
- Сохраните данные.
- Очистите данные.

### Dependency

- `BuildRequires: pkgconfig(qca2-qt5)`
- `PKGCONFIG += qca2-qt5`

### Example

```kotlin
const val keyBool = "keyBool"
const val keyInt = "keyInt"
const val keyLong = "keyLong"
const val keyFloat = "keyFloat"
const val keyDouble = "keyDouble"
const val keyString = "keyString"
const val keyListString = "keyListString"

class AuroraSharedPreferencesSecure {
    fun getBool(): Boolean {
        return SharedPreferencesSecure.getBool(keyBool, false)
    }

    fun getInt(): Int {
        return SharedPreferencesSecure.getInt(keyInt, 0)
    }

    fun getLong(): Long {
        return SharedPreferencesSecure.getLong(keyLong, 0)
    }

    fun getFloat(): Float {
        return SharedPreferencesSecure.getFloat(keyFloat, 0.0f)
    }

    fun getDouble(): Double {
        return SharedPreferencesSecure.getDouble(keyDouble, 0.0)
    }

    fun getString(): String {
        return SharedPreferencesSecure.getString(keyString, "-")
    }

    fun getListString(): List<String> {
        return SharedPreferencesSecure.getListString(keyListString, listOf())
    }

    fun drop() {
        SharedPreferencesSecure.drop()
    }

    fun refreshRandomData() {
        // Set data
        SharedPreferencesSecure.putBool(keyBool, Random.nextBoolean())
        SharedPreferencesSecure.putInt(keyInt, Random.nextInt())
        SharedPreferencesSecure.putLong(keyLong, Random.nextLong())
        SharedPreferencesSecure.putFloat(keyFloat, Random.nextFloat())
        SharedPreferencesSecure.putDouble(keyDouble, Random.nextDouble())
        SharedPreferencesSecure.putString(keyString, listOf("first", "second", "third").random())
        SharedPreferencesSecure.putListString(keyListString, listOf(
            listOf("first1", "second1", "third1"),
            listOf("first2", "second2", "third2"),
            listOf("first3", "second3", "third3"),
        ).random())
        // Save change
        SharedPreferencesSecure.save()
    }
}
```
