# Share Data

Библиотека для обмена данными из приложения через диалоговое окно общего доступа к платформе.

> For Aurora OS < 5.2

### Features:

- Поделиться данными.
- Поделиться текстом, как файлом.
- Поделиться файлом по пути.

### Dependency

- `LIBS += -ldbus-1`

### Example

```kotlin
class AuroraShareData {
    fun share(
        title: String,
        subject: String,
        body: String,
    ): Boolean {
        return ShareData.share(title, subject, body)
    }

    fun shareTextLikeFile(
        title: String,
        fileName: String,
        text: String,
    ): Boolean {
        return ShareData.shareTextLikeFile(title, fileName, text)
    }

    fun shareDataByPath(
        title: String,
        path: String,
    ): Boolean {
        return ShareData.shareDataByPath(title, path)
    }
}
```
