# Location Info

Библиотека для определения реального географического местоположения устройства.

### Features:

- Проверка поддержки.
- Метод получения местоположения.
- Прослушивание изменения состояния.

### Permissions

```
Permissions=Location;Internet
```

### Dependency

- `BuildRequires: pkgconfig(Qt5Location)`
- `BuildRequires: pkgconfig(Qt5Positioning)`
- `QT += location positioning`

### Example

```kotlin
var states: MutableMap<ULong, LocationState> = mutableMapOf()

class AuroraLocationInfo {

    fun isSupported(): Boolean {
        return LocationInfo.isSupported()
    }

    fun listen(): ULong {
        return LocationInfo.listen { id, value ->
            states.put(id, value)
        }
    }

    fun getState(id: ULong): String {
        return states[id]?.let { """
                lat: ${it.latitude.toString().take(12)},
                lon: ${it.longitude.toString().take(12)},
                alt: ${it.altitude.toString().take(12)}
            """.trimIndent() } ?: "loading..."
    }
}
```
