# Connectivity Info

Библиотека позволяет прослушивать тип состояния сетевого подключения.

### Features:

- Состояние в сети.
- Прослушивание изменения состояния.

### Permissions

```
Permissions=Internet
```

### Dependency

- `QT += network`

### Example

```kotlin
var states: MutableMap<ULong, ConnectivityInfoState> = mutableMapOf()

class AuroraConnectivityInfo {

    fun isOnline(): Boolean {
        return ConnectivityInfo.isOnline()
    }

    fun listen(): ULong {
        return ConnectivityInfo.listen { id, value ->
            states.put(id, value)
        }
    }

    fun getState(id: ULong): String {
        return states[id]?.name ?: "-"
    }
}
```
