# QtBindings - Qt/Qml

ОС Аврора, как и iOS, не имеет поддержки JVM. По этой причине Kotlin Multiplatform (KMP) доступен для этих платформ через нативные таргеты. Для ОС Аврора это `linuxX64` для эмулятора и `linuxArm64` для устройства.

При использовании таргетов `linuxX64` и `linuxArm64` есть возможность компиляции нативной статической или динамической С библиотеки, которая затем может быть подключена к вашему приложению. Используя такую библиотеку, вы можете разделять свою бизнес логику для ОС Аврора, вам остаётся лишь дописать нативный UI приложения, используя нативный фреймворк платформы --- `Qt/QML`.

Тем не менее такой подход сопряжён с некоторыми трудностями во время разработки:
- Генерируемый заголовочный файл содержит огромное количество строк, т. к. в нём располагается вся существующая бизнес-логика вашего проекта, в таком файле крайне затруднительно и неудобно ориентироваться;
- Экспортируемый интерфейс не поддерживает классы из сторонних библиотек, в том числе стандартные коллекции: список, хэш-таблицу;
- Получаемые из Kotlin ресурсы необходимо вручную освобождать с помощью вспомогательных экспортируемых функций: `DisposeString` для освобождения строк и `DisposeStablePointer` для освобождения каждого возвращаемого класса;
- В экспортируемом интерфейсе отсутствует привычный для разработчиков объектно-ориентированный интерфейс классов, в каждый метод необходимо передавать указатель на объект класса;
- Экспортируемый интерфейс не поддерживает работу с корутинами, они не экспортируются.

Все описанные выше проблемы возможно решить: обновить API экспортируемого Kotlin кода, чтобы он стал удобнее, исключить из него работу со стандартными коллекциями, написать вручную Qt классы-обёртки для экспортируемых Kotlin классов, которые будут конвертировать типы между фреймворками (Qt, KMP) и автоматически освобождать ресурсы. Но такое решение затрудняет работу с другими платформами из-за изменения API экспортируемого Kotlin кода, вынуждает вас писать большое количество шаблонного кода, который нужно изменять при каждом изменении Kotlin кода.

Инструмент **QtBindings** позволяет автоматизировать описанный выше процесс. С помощью **QtBindings** в текущей реализации можно:
- Генерировать обёртки для верхнеуровневых классов и функций;
- Использовать корутины в `Qt` с помощью `QFuture`;
- Работать с Kotlin списками (`List`, `MutableList`), они автоматически конвертируются в `QList`.
