# Ktor

**[<span class="icon material-symbols-outlined">link</span>mos.hub](https://hub.mos.ru/auroraos/kotlin-multiplatform/libraries/ktor)**

[Ktor](https://ktor.io/docs/client-create-multiplatform-application.html)
доступен на ОС Аврора через [Engine Curl](https://ktor.io/docs/client-engines.html#curl).
Он потребовал некоторых доработок для работы на ОС Аврора.
Для работы с ним необходимо будет собрать и опубликовать в [Maven Local Repositories](https://maven.apache.org/repositories/local.html).

## Публикация в Maven Local

Для сборки и публикации в `Maven Local` нужно клонировать открытый проект из mos.hub:

```shell
git clone https://hub.mos.ru/auroraos/kotlin-multiplatform/libraries/ktor.git
```

Затем перейти в директорию с проектом и выполнить команду:

```shell
./gradlew ktor-client:ktor-client-curl:publishLinuxPublicationsToMavenLocal \
    ktor-client:ktor-client-curl:publishKotlinMultiplatformPublicationToMavenLocal \
    --no-scan
```

Эта команда соберет проект и опубликует его в `Maven Local`.

## Подключение Maven Local

Для активации `Maven Local` в проекте, необходимо добавить `mavenLocal()` в файле `settings.gradle.kts`:

```kotlin
dependencyResolutionManagement {
    repositories {
        google()
        mavenCentral()
        mavenLocal()
    }
}
```

## Подключение Engine Curl

> Для работы `ktor-client-curl` требуется динамическая библиотека `zlib`, подключить ее можно указав в qmake (*.pro файл) `LIBS += -lz`.

После публикации плагина в `Maven Local` плагин можно подключить:

```kotlin
nativeMain.dependencies {
    implementation("io.ktor:ktor-client-curl:3.1.2-aurora")
}
```

Остальные компоненты Ktor не требуют модификаций и нужно использовать upstream версию.
