# Aurora KInterop

**[<span class="icon material-symbols-outlined">link</span>mos.hub](https://hub.mos.ru/auroraos/kotlin-multiplatform/libraries/aurora-kinterop)**

Набор библиотек обеспечивающий взаимодействие с системой ОС Аврора для проектов KMP.

Проект предоставляет самодостаточные библиотеки KMP, которые можно использовать отдельно друг от друга.
Используя Kotlin
[c-interop](https://kotlinlang.org/docs/native-c-interop.html)
библиотеки взаимодействуют с низкоуровневыми с-библиотекам обеспечивающим основную работу с ОС Аврора.

> Рекомендуемый вариант использования - статический.
> Он минимизирует сложности, все библиотеки работают с regular-подписью.

### Сборка и публикация

Библиотеки можно использовать через локальный репозиторий,
для этого необходимо клонировать проект и в корне его выполнить команду:

```shell
./gradlew build publishToMavenLocal
```

После этого библиотеки будут доступны в `mavenLocal()`.

### Demo Aurora Interop

Для демонстрации работы библиотек было разработано приложение `Demo Aurora Interop`.
В нем можно найти использование всех библиотек `Aurora KInterop`.
Используя Qt/QML как основу приложения, KMP модуль выполняет всю работу.

[Подробнее](../examples/demo-aurora-interop.md)
