# Shared Preferences

Библиотека позволяет хранить настройки в виде пар ключ-значение.

### Features:

- Set/Get Boolean.
- Set/Get Int.
- Set/Get Long.
- Set/Get Float.
- Set/Get Double.
- Set/Get String.
- Set/Get List<String>.
- Проверьте, существует ли значение.
- Сохраните данные.
- Очистите данные.

### Example

```kotlin
const val keyBool = "keyBool"
const val keyInt = "keyInt"
const val keyLong = "keyLong"
const val keyFloat = "keyFloat"
const val keyDouble = "keyDouble"
const val keyString = "keyString"
const val keyListString = "keyListString"

class AuroraSharedPreferences {
    fun getBool(): Boolean {
        return SharedPreferences.getBool(keyBool, false)
    }

    fun getInt(): Int {
        return SharedPreferences.getInt(keyInt, 0)
    }

    fun getLong(): Long {
        return SharedPreferences.getLong(keyLong, 0)
    }

    fun getFloat(): Float {
        return SharedPreferences.getFloat(keyFloat, 0.0f)
    }

    fun getDouble(): Double {
        return SharedPreferences.getDouble(keyDouble, 0.0)
    }

    fun getString(): String {
        return SharedPreferences.getString(keyString, "-")
    }

    fun getListString(): List<String> {
        return SharedPreferences.getListString(keyListString, listOf())
    }

    fun drop() {
        SharedPreferences.drop()
    }

    fun refreshRandomData() {
        // Set data
        SharedPreferences.putBool(keyBool, Random.nextBoolean())
        SharedPreferences.putInt(keyInt, Random.nextInt())
        SharedPreferences.putLong(keyLong, Random.nextLong())
        SharedPreferences.putFloat(keyFloat, Random.nextFloat())
        SharedPreferences.putDouble(keyDouble, Random.nextDouble())
        SharedPreferences.putString(keyString, listOf("first", "second", "third").random())
        SharedPreferences.putListString(keyListString, listOf(
            listOf("first1", "second1", "third1"),
            listOf("first2", "second2", "third2"),
            listOf("first3", "second3", "third3"),
        ).random())
        // Save change
        SharedPreferences.save()
    }
}
```
