# Sensors Info

Библиотека обеспечивает доступ к данным датчиков.

### Features:

- Датчик Accelerometer.
- Датчик AmbientLight.
- Датчик Compass.
- Датчик Gyroscope.
- Датчик Magnetometer.
- Датчик Orientation.
- Датчик Pressure.
- Датчик Proximity.
- Датчик Rotation.
- Датчик Tap.

### Permissions

```
Permissions=Sensors
```

### Dependency

- `BuildRequires: pkgconfig(Qt5Sensors)`
- `QT += sensors`

### Example

```kotlin
var statesAccelerometer: MutableMap<ULong, AccelerometerState> = mutableMapOf()
var statesAmbientLight: MutableMap<ULong, AmbientLightSensorState> = mutableMapOf()
var statesCompass: MutableMap<ULong, CompassState> = mutableMapOf()
var statesGyroscope: MutableMap<ULong, GyroscopeState> = mutableMapOf()
var statesMagnetometer: MutableMap<ULong, MagnetometerState> = mutableMapOf()
var statesOrientation: MutableMap<ULong, OrientationState> = mutableMapOf()
var statesPressure: MutableMap<ULong, PressureState> = mutableMapOf()
var statesProximity: MutableMap<ULong, ProximityState> = mutableMapOf()
var statesRotation: MutableMap<ULong, RotationState> = mutableMapOf()
var statesTap: MutableMap<ULong, TapState> = mutableMapOf()

class AuroraSensorsInfo {

    // Accelerometer
    fun listenAccelerometer(): ULong {
        return SensorsInfo.accelerometer.listen { id, value ->
            statesAccelerometer.put(id, value)
        }
    }

    fun getStateAccelerometer(id: ULong): String {
        return statesAccelerometer[id]?.let { """
                x: ${it.x.toString().take(12)}
                y: ${it.y.toString().take(12)}
                z: ${it.z.toString().take(12)}
            """.trimIndent() } ?: "-"
    }

    // AmbientLight
    fun listenAmbientLight(): ULong {
        return SensorsInfo.ambientLight.listen { id, value ->
            statesAmbientLight.put(id, value)
        }
    }

    fun getStateAmbientLight(id: ULong): String {
        return statesAmbientLight[id]?.name ?: "-"
    }

    // Compass
    fun listenCompass(): ULong {
        return SensorsInfo.compass.listen { id, value ->
            statesCompass.put(id, value)
        }
    }

    fun getStateCompass(id: ULong): String {
        return statesCompass[id]?.let { """
                azimuth: ${it.azimuth.toString().take(12)}
                level: ${it.calibrationLevel.toString().take(12)}
            """.trimIndent() } ?: "-"
    }

    // Gyroscope
    fun listenGyroscope(): ULong {
        return SensorsInfo.gyroscope.listen { id, value ->
            statesGyroscope.put(id, value)
        }
    }

    fun getStateGyroscope(id: ULong): String {
        return statesGyroscope[id]?.let { """
                x: ${it.x.toString().take(12)}
                y: ${it.y.toString().take(12)}
                z: ${it.z.toString().take(12)}
            """.trimIndent() } ?: "-"
    }

    // Magnetometer
    fun listenMagnetometer(): ULong {
        return SensorsInfo.magnetometer.listen { id, value ->
            statesMagnetometer.put(id, value)
        }
    }

    fun getStateMagnetometer(id: ULong): String {
        return statesMagnetometer[id]?.let { """
                x: ${it.x.toString().take(12)}
                y: ${it.y.toString().take(12)}
                z: ${it.z.toString().take(12)}
            """.trimIndent() } ?: "-"
    }

    // Orientation
    fun listenOrientation(): ULong {
        return SensorsInfo.orientation.listen { id, value ->
            statesOrientation.put(id, value)
        }
    }

    fun getStateOrientation(id: ULong): String {
        return statesOrientation[id]?.name ?: "-"
    }

    // Pressure
    fun listenPressure(): ULong {
        return SensorsInfo.pressure.listen { id, value ->
            statesPressure.put(id, value)
        }
    }

    fun getStatePressure(id: ULong): String {
        return statesPressure[id]?.let { """
                pressure: ${it.pressure.toString().take(12)}
            """.trimIndent() } ?: "-"
    }

    // Proximity
    fun listenProximity(): ULong {
        return SensorsInfo.proximity.listen { id, value ->
            statesProximity.put(id, value)
        }
    }

    fun getStateProximity(id: ULong): String {
        return statesProximity[id]?.let { """
                isClose: ${it.isClose}
            """.trimIndent() } ?: "-"
    }

    // Rotation
    fun listenRotation(): ULong {
        return SensorsInfo.rotation.listen { id, value ->
            statesRotation.put(id, value)
        }
    }

    fun getStateRotation(id: ULong): String {
        return statesRotation[id]?.let { """
                x: ${it.x.toString().take(12)}
                y: ${it.y.toString().take(12)}
                z: ${it.z.toString().take(12)}
            """.trimIndent() } ?: "-"
    }

    // Tap
    fun listenTap(): ULong {
        return SensorsInfo.tap.listen { id, value ->
            statesTap.put(id, value)
        }
    }

    fun getStateTap(id: ULong): String {
        return statesTap[id]?.let { """
                direction: ${it.tapDirection.toString().take(12)}
                isDouble: ${it.isDoubleTap.toString().take(12)}
            """.trimIndent() } ?: "-"
    }
}
```
