# Path Info

Библиотека позволяющая получить информацию о путях файловой системе.

### Features:

- Путь к приложению кэширования.
- Путь к приложению данных.
- Путь к локальному приложению кэширования.
- Путь к локальному приложению данных.
- Путь к приложению файлов.
- Путь к приложению переводов.
- Путь к общему кэшу организации.
- Путь к общим данным организации.
- Путь к общим файлам организации.
- Путь к локальному кэшу организации.
- Путь к локальным данным организации.
- Путь к папке шрифтов.
- Путь к папке сменных носителей.
- Путь к папке среды выполнения.
- Путь к временной папке.
- Путь к домашней папке.
- Путь к папке рабочего стола.
- Путь к папке документов.
- Путь к папке загрузок.
- Путь к папке видео.
- Путь к папке музыки.
- Путь к папке изображений.

### Permissions

```
Permissions=UserDirs
```

### Dependency

- `LIBS += -lappdir`

### Example

```kotlin
class AuroraPathInfo {
    fun getAppCache(): String {
        return PathInfo.getAppCache()
    }

    fun getAppData(): String {
        return PathInfo.getAppData()
    }

    fun appLocalCache(): String {
        return PathInfo.appLocalCache()
    }

    fun getAppLocalData(): String {
        return PathInfo.getAppLocalData()
    }

    fun getPackageFiles(): String {
        return PathInfo.getPackageFiles()
    }

    fun getTranslations(): String {
        return PathInfo.getTranslations()
    }

    fun getOrgCache(): String {
        return PathInfo.getOrgCache()
    }

    fun getOrgData(): String {
        return PathInfo.getOrgData()
    }

    fun getOrgFiles(): String {
        return PathInfo.getOrgFiles()
    }

    fun getOrgLocalCache(): String {
        return PathInfo.getOrgLocalCache()
    }

    fun getOrgLocalData(): String {
        return PathInfo.getOrgLocalData()
    }

    fun getFonts(): String {
        return PathInfo.getFonts()
    }

    fun getRemovableMedia(): String {
        return PathInfo.getRemovableMedia()
    }

    fun getRuntime(): String {
        return PathInfo.getRuntime()
    }

    fun getTemp(): String {
        return PathInfo.getTemp()
    }

    fun getHome(): String {
        return PathInfo.getHome()
    }

    fun getDesktop(): String {
        return PathInfo.getDesktop()
    }

    fun getDocuments(): String {
        return PathInfo.getDocuments()
    }

    fun getDownloads(): String {
        return PathInfo.getDownloads()
    }

    fun getVideos(): String {
        return PathInfo.getVideos()
    }

    fun getMusic(): String {
        return PathInfo.getMusic()
    }

    fun getPictures(): String {
        return PathInfo.getPictures()
    }
}
```
