# Package Info

Библиотека, позволяющая получить информацию о текущем пакете, установленном в системе.

### Features:

- Полный идентификатор пакета.
- Идентификатор имени приложения.
- Идентификатор организации приложения.
- Версия приложения с релизом.
- Группа пакета.
- Размер всего каталога установленного пакета.
- Размер каталога bin с исполняемым файлом.
- Размер каталога с данными пакета.
- Размер каталога с библиотеками пакета.

### Example

```kotlin
class AuroraPackageInfo {
    fun getApplicationId(): String {
        return PackageInfo.getApplicationId()
    }

    fun getAppName(): String {
        return PackageInfo.getAppName()
    }

    fun getOrgName(): String {
        return PackageInfo.getOrgName()
    }

    fun getVersion(): String {
        return PackageInfo.getVersion()
    }

    fun getSubgroup(): String {
        return PackageInfo.getSubgroup()
    }

    fun getSize(): ULong {
        return PackageInfo.getSize()
    }

    fun getSizeBin(): ULong {
        return PackageInfo.getSizeBin()
    }

    fun getSizeData(): ULong {
        return PackageInfo.getSizeData()
    }

    fun getSizeDataLib(): ULong {
        return PackageInfo.getSizeDataLib()
    }
}
```
