# Device Info

Библиотека, позволяющая получить информацию об устройстве.

### Device General

– Уникальный идентификатор устройства.
– Глобальная навигационная спутниковая система.
– Беспроводная связь ближнего радиуса действия.
– Стандарт беспроводной связи малого радиуса действия.
– Беспроводная локальная сеть.
– Максимальная зарегистрированная тактовая частота процессора.
– Количество ядер системы.
– Текущий заряд аккумулятора в процентах.
– Разрешение основной камеры.
– Разрешение фронтальной камеры.
– Общий объём оперативной памяти.
– Свободный объём оперативной памяти.
– Чёткость и детализация изображения на устройстве.
– Версия операционной системы.
– Название модели устройства.

### Device SIM Cards

- Информация о SIM-картах устройства.

### Device Storages

- Информация о внешнем хранилище устройства.
- Информация о внутреннем хранилище устройства.

### Permissions

```
Permissions=DeviceInfo
```

### Dependency

- `LIBS += -ldbus-1`

### Example

```kotlin
class AuroraDeviceInfo {
    fun id(): String {
        return DeviceInfo.id()
    }

    fun hasGNSS(): Boolean {
        return DeviceInfo.hasGNSS()
    }

    fun hasNFC(): Boolean {
        return DeviceInfo.hasNFC()
    }

    fun hasBluetooth(): Boolean {
        return DeviceInfo.hasBluetooth()
    }

    fun hasWlan(): Boolean {
        return DeviceInfo.hasWlan()
    }

    fun getMaxCpuClockSpeed(): UInt {
        return DeviceInfo.getMaxCpuClockSpeed()
    }

    fun getNumberCpuCores(): UInt {
        return DeviceInfo.getNumberCpuCores()
    }

    fun getBatteryChargePercentage(): UInt {
        return DeviceInfo.getBatteryChargePercentage()
    }

    fun getMainCameraResolution(): Double {
        return DeviceInfo.getMainCameraResolution()
    }

    fun getFrontalCameraResolution(): Double {
        return DeviceInfo.getFrontalCameraResolution()
    }

    fun getRamTotalSize(): ULong {
        return DeviceInfo.getRamTotalSize()
    }

    fun getRamFreeSize(): ULong {
        return DeviceInfo.getRamFreeSize()
    }

    fun getScreenResolution(): String {
        return DeviceInfo.getScreenResolution()
    }

    fun getOsVersion(): String {
        return DeviceInfo.getOsVersion()
    }

    fun getDeviceModel(): String {
        return DeviceInfo.getDeviceModel()
    }
}

data class SharedSimCard(
    val enabled: Boolean,
    val operatorName: String,
    val preferredDataTransfer: Boolean,
    val preferredVoiceCall: Boolean,
    val simName: String,
)

class AuroraSimCards {
    fun getSimCardsInfo(): List<SharedSimCard> {
        return DeviceSim.getSimCardsInfo().map {
            SharedSimCard(
                enabled = it.enabled,
                operatorName = it.operatorName,
                preferredDataTransfer = it.preferredDataTransfer,
                preferredVoiceCall = it.preferredVoiceCall,
                simName = it.simName,
            )
        }
    }
}

data class SharedExternalStorage(
    val bytesAvailable: ULong,
    val bytesTotal: ULong,
    val bytesUsed: ULong,
    val countMountedPartitions: UInt,
    val deviceLabel: String,
    val mounted: Boolean,
)

data class SharedInternalStorage(
    val bytesAvailable: ULong,
    val bytesTotal: ULong,
    val bytesUsed: ULong,
    val deviceLabel: String,
    val filesystemType: String,
)

class AuroraStorageInfo {
    fun getExternalInfo(): SharedExternalStorage {
        return DeviceStorage.getExternalInfo().let {
            SharedExternalStorage(
                bytesAvailable = it.bytesAvailable,
                bytesTotal = it.bytesTotal,
                bytesUsed = it.bytesUsed,
                countMountedPartitions = it.countMountedPartitions,
                deviceLabel = it.deviceLabel,
                mounted = it.mounted,
            )
        }
    }

    fun getInternalInfo(): SharedInternalStorage {
        return DeviceStorage.getInternalInfo().let {
            SharedInternalStorage(
                bytesAvailable = it.bytesAvailable,
                bytesTotal = it.bytesTotal,
                bytesUsed = it.bytesUsed,
                deviceLabel = it.deviceLabel,
                filesystemType = it.filesystemType,
            )
        }
    }
}
```
