# Camera Info

Библиотека позволяет получить информацию о камерах устройства.

### Features:

- Получение информации о камерах.
- Получение информации о количестве камер.

### Dependency

- `BuildRequires: pkgconfig(streamcamera)`
- `PKGCONFIG += streamcamera`

### Example

```kotlin
data class SharedCameraInfo(
    val id: String,
    val name: String,
    val provider: String,
    val mountAngle: Int,
)

class AuroraCameraInfo {
    fun getSharedCameraInfo(): List<SharedCameraInfo> {
        return CameraInfo.getInfoList().map {
            SharedCameraInfo(
                id = it.id,
                name = it.name,
                provider = it.provider,
                mountAngle = it.mountAngle,
            )
        }
    }

    fun getInfoCount(): ULong {
        return CameraInfo.getInfoCount()
    }
}
```
