# Battery Info

Библиотека для доступа к информации об аккумуляторе устройства.

### Features

- Уровень заряда аккумулятора.
- Состояние зарядного устройства.
- Прослушивание состояния зарядного устройства.

### Permissions

```
Permissions=DeviceInfo
```

### Dependency

- `LIBS += -ldbus-1`

### Example

```kotlin
var states: MutableMap<ULong, Boolean> = mutableMapOf()

class AuroraBatteryInfo {

    fun getLevel(): Int {
        return BatteryInfo.getLevel()
    }

    fun listen(): ULong {
        return BatteryInfo.listenCharger { id, value ->
            states.put(id, value)
        }
    }

    fun getStateCharger(id: ULong): Boolean {
        return states[id] ?: false
    }
}
```
