#ifndef LIB_FLUTTER_EMBEDDER_EVENT_CHANNEL_H
#define LIB_FLUTTER_EMBEDDER_EVENT_CHANNEL_H

#include <functional>
#include <memory>
#include <string>

#include "encodable.h"
#include "export.h"
#include "method-codec-interface.h"
#include "method-codec-type.h"
#include "method-response.h"

typedef struct _FlutterPlatformMessageResponseHandle FlutterResponseHandleFwd;

typedef MethodResponse EventResponse;
typedef std::function<EventResponse(const Encodable &message)> EventHandler;

class EMBEDDER_EXPORT EventChannel final
{
public:
    EventChannel() = default;
    EventChannel(const std::string &channel, MethodCodecType codec);

public:
    void SendEvent(const Encodable &event);
    void SendEndOfStream();
    void SendError(const std::string &errorCode,
                   const std::string &errorMessage,
                   const Encodable &errorDetails);

private:
    friend class PluginRegistrar;
    void SetEventHandlers(const EventHandler &onListen, const EventHandler &onCancel);

private:
    void messageCallback(const std::vector<uint8_t> &message,
                         const FlutterResponseHandleFwd *responseHandle,
                         const EventHandler &onListen,
                         const EventHandler &onCancel);

private:
    std::string m_channel;
    std::shared_ptr<IMethodCodec> m_codec;
};

#endif /* LIB_FLUTTER_EMBEDDER_EVENT_CHANNEL_H */
