#ifndef LIB_FLUTTER_EMBEDDER_PLATFORM_METHODS_H
#define LIB_FLUTTER_EMBEDDER_PLATFORM_METHODS_H

#include "export.h"
#include "platform-types.h"

#include <EGL/egl.h>
#include <string>

class EMBEDDER_EXPORT PlatformMethods
{
public:
    static std::string GetApplicationID();
    static std::string GetOrgname();
    static std::string GetAppname();
    static double GetKeyboardHeight();
    static void WindowMaximize();
    static void WindowMinimize();
    static EGLDisplay GetEGLDisplay();
    static EGLContext GetEGLContext();
    static DisplayOrientation GetOrientation();
    static int32_t GetDisplayWidth();
    static int32_t GetDisplayHeight();
};

#endif /* LIB_FLUTTER_EMBEDDER_PLATFORM_METHODS_H */
