#ifndef LIB_FLUTTER_EMBEDDER_COMPATIBILITY_H
#define LIB_FLUTTER_EMBEDDER_COMPATIBILITY_H

#include <QCoreApplication>
#include "application.h"

/**
 * Add support for Qt signals and slots in a Flutter applications.
 *
 * This function should only be called after the flutter application
 * has been initialized.
 *
 * The developer must manually link Qt5::Core to the application in
 * the `./aurora/CMakeLists.txt` file, since this library does not
 * link directly with Qt5::Core.
 */
void EnableQtCompatibility()
{
    struct QSource
    {
        GSource source;
        QCoreApplication *application;
    };

    static QSource *qsource = nullptr;
    static GSourceFuncs funcs = {
        [](GSource *, gint *timeout) -> gboolean {
            *timeout = 0;
            return G_SOURCE_CONTINUE;
        },
        [](GSource *) -> gboolean {
            return G_SOURCE_CONTINUE;
        },
        [](GSource *gsource, GSourceFunc, gpointer) -> gboolean {
            reinterpret_cast<QSource *>(gsource)->application->processEvents();
            return G_SOURCE_CONTINUE;
        },
        nullptr,
        nullptr,
        nullptr,
    };

    if (!qsource) {
        /*
            Since the `Application` class is a singleton and lives for
            the entire execution of the program, let's trust the cleaning
            of memory allocated for `QSource` to the operating system
            when the process terminates.
        */

       static int argc = 1;
       static char *argv[] = {""};

        qsource = reinterpret_cast<QSource *>(g_source_new(&funcs, sizeof(QSource)));
        qsource->application = new QCoreApplication(argc, argv);

        Application::AttachEventSource(&qsource->source);
    }
}

#endif /* LIB_FLUTTER_EMBEDDER_COMPATIBILITY_H */
