#ifndef LIB_FLUTTER_EMBEDDER_TEXTURE_VARIANT_H
#define LIB_FLUTTER_EMBEDDER_TEXTURE_VARIANT_H

#include <cassert>
#include <functional>
#include <memory>
#include <cstdint>
#include <string>
#include <variant>
#include <optional>

typedef struct
{
    std::shared_ptr<uint8_t> buffer;
    size_t width;
    size_t height;
} FlutterPixelBuffer;

typedef std::variant<FlutterPixelBuffer> BufferVariant;

typedef std::function<bool(size_t width, size_t height)> TextureBuilder;

typedef std::function<std::optional<BufferVariant>(size_t width, size_t height)> TextureBufferBuilder;

#endif /* LIB_FLUTTER_EMBEDDER_TEXTURE_VARIANT_H */
