#ifndef LIB_FLUTTER_EMBEDDER_METHOD_RESPONSE_H
#define LIB_FLUTTER_EMBEDDER_METHOD_RESPONSE_H

#include "encodable.h"
#include "export.h"

class EMBEDDER_EXPORT MethodResponse final
{
public:
    MethodResponse() = default;

    MethodResponse(const Encodable &result);
    MethodResponse(const std::string &errorCode,
                   const std::string &errorMessage,
                   const Encodable &errorDetails);

public:
    bool HasError() const;

    const Encodable &GetResult() const;
    const std::string &GetErrorCode() const;
    const std::string &GetErrorMessage() const;
    const Encodable &GetErrorDetails() const;

private:
    Encodable m_result;
    std::string m_errorCode;
    std::string m_errorMessage;
    Encodable m_errorDetails;
    bool m_error;
};

#endif /* LIB_FLUTTER_EMBEDDER_METHOD_RESPONSE_H */
