#ifndef LIB_FLUTTER_EMBEDDER_METHOD_CHANNEL_H
#define LIB_FLUTTER_EMBEDDER_METHOD_CHANNEL_H

#include <functional>
#include <memory>
#include <string>

#include "encodable.h"
#include "export.h"
#include "method-call.h"
#include "method-codec-interface.h"
#include "method-codec-type.h"
#include "method-response.h"

typedef struct _FlutterPlatformMessageResponseHandle FlutterResponseHandleFwd;

typedef std::function<void(const MethodCall &call)> MethodCallHandler;
typedef std::function<void(const MethodResponse &response)> MethodCallReply;

class EMBEDDER_EXPORT MethodChannel final
{
public:
    MethodChannel() = default;
    MethodChannel(const std::string &channel, MethodCodecType codec);

public:
    void InvokeMethod(const std::string &method, const Encodable &arguments);
    void InvokeMethod(const std::string &method,
                      const Encodable &arguments,
                      const MethodCallReply &onReplyCallback);

private:
    friend class PluginRegistrar;
    void SetMethodCallHandler(const MethodCallHandler &onMethodCall);

private:
    void messageCallback(const std::vector<uint8_t> &message,
                         const FlutterResponseHandleFwd *responseHandle,
                         const MethodCallHandler &onMethodCall);

private:
    std::string m_channel;
    std::shared_ptr<IMethodCodec> m_codec;
};

#endif /* LIB_FLUTTER_EMBEDDER_METHOD_CHANNEL_H */
