#ifndef LIB_FLUTTER_EMBEDDER_MESSAGE_CODEC_INTERFACE_H
#define LIB_FLUTTER_EMBEDDER_MESSAGE_CODEC_INTERFACE_H

#include <vector>
#include "encodable.h"

class IMessageCodec
{
public:
    virtual ~IMessageCodec() = default;

public:
    virtual Encodable DecodeMessage(const std::vector<uint8_t> &data) const = 0;
    virtual std::vector<uint8_t> EncodeMessage(const Encodable &value) const = 0;
};

#endif /* LIB_FLUTTER_EMBEDDER_MESSAGE_CODEC_INTERFACE_H */
