#ifndef LIB_FLUTTER_EMBEDDER_BASIC_MESSAGE_H
#define LIB_FLUTTER_EMBEDDER_BASIC_MESSAGE_H

#include <memory>

#include "encodable.h"
#include "export.h"
#include "message-codec-interface.h"

typedef struct _FlutterPlatformMessageResponseHandle FlutterResponseHandleFwd;

class EMBEDDER_EXPORT BasicMessage final
{
private:
    friend class BasicMessageChannel;
    BasicMessage(std::shared_ptr<IMessageCodec> codec,
                 const Encodable &value,
                 const FlutterResponseHandleFwd *responseHandle);

public:
    const Encodable &GetValue() const;
    void SendResponse(const Encodable &value);

private:
    std::shared_ptr<IMessageCodec> m_codec;
    Encodable m_value;
    const FlutterResponseHandleFwd *m_responseHandle;
};

#endif /* LIB_FLUTTER_EMBEDDER_BASIC_MESSAGE_CHANNEL_H */
