#ifndef LIB_FLUTTER_EMBEDDER_BASIC_MESSAGE_CHANNEL_H
#define LIB_FLUTTER_EMBEDDER_BASIC_MESSAGE_CHANNEL_H

#include <functional>
#include <string>

#include "basic-message.h"
#include "encodable.h"
#include "export.h"
#include "message-codec-type.h"

typedef struct _FlutterPlatformMessageResponseHandle FlutterResponseHandleFwd;

typedef std::function<void(const BasicMessage &message)> MessageHandler;
typedef std::function<void(const Encodable &response)> MessageReply;

class EMBEDDER_EXPORT BasicMessageChannel final
{
public:
    BasicMessageChannel() = default;
    BasicMessageChannel(const std::string &channel, MessageCodecType codec);

public:
    void SendMessage(const Encodable &value);
    void SendMessage(const Encodable &value, const MessageReply &onReply);

private:
    friend class PluginRegistrar;
    void SetMessageHandler(const MessageHandler &onMessage);

private:
    void messageCallback(const std::vector<uint8_t> &message,
                         const FlutterResponseHandleFwd *responseHandle,
                         const MessageHandler &onMessage);

private:
    std::string m_channel;
    std::shared_ptr<IMessageCodec> m_codec;
};

#endif /* LIB_FLUTTER_EMBEDDER_BASIC_MESSAGE_CHANNEL_H */
